# Part of the StreamDVD project

package StreamDVD::Audio;

use strict;
use vars qw($VERSION @ISA @EXPORT);

require Exporter;

@ISA = qw(Exporter);
@EXPORT = qw(

);


$VERSION = '0.1';

sub new {                                                  # create new audio object
   my $class = shift;
   my $self = bless {}, $class;

   return $self;
}



sub id {                                                   # get/set audio stream id
   my $self = shift;
   my ($value) = @_;
   $self->{ID} = $value if(defined $value);
   return $self->{ID};
}



sub num {                                                  # get/set audio stream number
   my $self = shift;
   my ($value) = @_;
   $self->{NUM} = $value if(defined $value);
   return $self->{NUM};
}



sub format {                                               # get/set audio type (ac3, dts, ..)
   my $self = shift;
   my ($value) = @_;
   $self->{TYPE} = $value if(defined $value);
   return $self->{TYPE};
}



sub langcode {                                             # get/set audio language code
   my $self = shift;
   my ($value) = @_;
   $self->{LANG} = $value if(defined $value);
   return $self->{LANG};
}



sub language {                                             # get/set audio language
   my $self = shift;
   my ($value) = @_;
   $self->{LANGUAGE} = $value if(defined $value);
   return $self->{LANGUAGE};
}



sub channel {                                              # get/set channel count
   my $self = shift;
   my ($value) = @_;
   $self->{CHANNEL} = $value if(defined $value);
   return $self->{CHANNEL};
}



sub freq {                                                 # get/set frequenz (48kHz, ...)
   my $self = shift;
   my ($value) = @_;
   $self->{FREQ} = $value if(defined $value);
   return $self->{FREQ};
}



sub quant {                                                # get/set quantization
   my $self = shift;
   my ($value) = @_;
   $self->{QUANT} = $value if(defined $value);
   return $self->{QUANT};
}



sub content {                                              # get/set content description
   my $self = shift;
   my ($value) = @_;
   $self->{CONTENT} = $value if(defined $value);
   return $self->{CONTENT};
}



;










package StreamDVD::Subtitle;

use strict;
use vars qw($VERSION @ISA @EXPORT);

require Exporter;

@ISA = qw(Exporter);
@EXPORT = qw(

);


$VERSION = '0.10';
use StreamDVD::Defs;

sub new {                                                  # create new title object
   my $class = shift;
   my $self = bless {}, $class;

   return $self;
}



sub num {                                                  # get/set subtitle number
   my $self = shift;
   my ($value) = @_;
   $self->{NUM} = $value if(defined $value);
   return $self->{NUM};
}



sub id {                                                   # get/set subtitle stream id
   my $self = shift;
   my ($value) = @_;
   $self->{ID} = $value if(defined $value);
   return $self->{ID};
}



sub langcode {                                             # get/set subtitle langcode
   my $self = shift;
   my ($value) = @_;
   $self->{LANGCODE} = $value if(defined $value);
   return $self->{LANGCODE};
}



sub language {                                             # get/set subtitle language
   my $self = shift;
   my ($value) = @_;
   $self->{LANGUAGE} = $value if(defined $value);
   return $self->{LANGUAGE};
}



sub content {                                              # get/set subtitle content description
   my $self = shift;
   my ($value) = @_;
   $self->{CONTENT} = $value if(defined $value);
   return $self->{CONTENT};
}





1;

